 ; Ŀ
 ;   Shark - find and erase all entities under a certain size.             
 ;   Copyright 1996 by Rocket Software                                     
 ;   Actually they make very nice pets.                                    
 ; 

 ; Ŀ
 ;   Subroutine Cartlg: returns the length of an arc.                      
 ; 
 (DEFUN CARTLG (arcent / cent stangl endang radd incang incdeg arclen)
 ; Ŀ
 ;   Get various entity data.                                              
 ; 
  (setq cent (cdr (assoc 10 arcent)))
  (setq stangl (cdr (assoc 50 arcent)))
  (setq endang (cdr (assoc 51 arcent)))
  (setq radd (cdr (assoc 40 arcent)))
  (if (> stangl endang)
      (setq incang (- (* 2 pi) (- stangl endang)))
      (setq incang (abs (- stangl endang))))
 ; Ŀ
 ;   Now calculate the length: pi*radius*included_angle/180.               
 ; 
  (setq incdeg (* 180 (/ incang pi)))
  (setq arclen (/ (* pi radd incdeg) 180))
 arclen)
 ; Ŀ
 ;   Cartlg end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Tail: find the total length of a polyline.                 
 ; 
 (DEFUN TAIL (enam / entt pa pb dist)
  (setq dist 0)
  (while (/= (cdr (assoc 0 (setq entt (entget (setq enam (entnext enam))))))
                                                                    "SEQEND")
         (if pa (setq pb pa))
         (setq pa (cdr (assoc 10 entt)))
         (if (and pa pb) (setq dist (+ dist (distance pa pb)))))
 dist)
 ; Ŀ
 ;   Tail end.                                                             
 ; 

 ; Ŀ
 ;   Shark.                                                                
 ; 
 (DEFUN C:SHARK (/ ss mindp pos curr rad num enam entt pa elvn dell)
  (setvar "cmdecho" 0)
  (command "undo" "M")
 ; Ŀ
 ;   Get minimum acceptable length and set marker x length.                
 ; 
  (if (null mind) (setq mind (/ (getvar "Dimscale") 20)))
  (setq mindp (getdist (strcat "Minimum allowable size <"
                               (rtos mind 2 2) ">: ")))
  (if mindp (setq mind mindp))
  (setq rad (* (getvar "viewsize") 0.05))
 ; Ŀ
 ;   Lines: find all, see if any are below the minimum length, if so       
 ;   mark them.  Remove other lines from the ss.                           
 ; 
  (if (setq ss (ssget "X" (list (cons 0 "LINE"))))
      (setq num (itoa (sslength ss)))
      (setq num "0"))
  (write-line (strcat "\nLines found: " num))
  (setq num (strcat "/" num))
  (setq pos 0)
  (setq curr 1)
  (while (and ss (setq enam (ssname ss pos)))
         (grtext -2 (strcat (itoa curr) num))
         (setq curr (1+ curr))
         (setq entt (entget enam))
         (setq pa (cdr (assoc 10 entt)))
         (setq elvn (cdr (assoc 11 entt)))
         (if (> mind (distance pa elvn))
             (progn
                  (grdraw (polar pa (/ pi 4) rad)
                          (polar pa (* 1.25 pi) rad) 7)
                  (grdraw (polar pa (* pi 0.75) rad)
                          (polar pa (* pi 1.75) rad) 7)
                  (setq pos (1+ pos)))
             (ssdel enam ss)))
  (if ss 
      (progn
           (command "erase" ss "")
           (write-line (strcat "Lines deleted: " (itoa pos))))
      (write-line "No lines deleted."))
 ; Ŀ
 ;   Circles: find all, see if any are below the minimum radius, if so     
 ;   mark them.  Remove others from the ss.                                
 ; 
  (if (setq ss (ssget "X" (list (cons 0 "CIRCLE"))))
      (setq num (itoa (sslength ss)))
      (setq num "0"))
  (write-line (strcat "\nCircles found: " num))
  (setq num (strcat "/" num))
  (setq pos 0)
  (setq curr 1)
  (while (and ss (setq enam (ssname ss pos)))
         (grtext -2 (strcat (itoa curr) num))
         (setq curr (1+ curr))
         (setq entt (entget enam))
         (setq pa (cdr (assoc 10 entt)))
         (setq diam (* 2 (cdr (assoc 40 entt))))
         (if (> mind diam)
             (progn
                  (grdraw (polar pa (/ pi 4) rad)
                          (polar pa (* 1.25 pi) rad) 7)
                  (grdraw (polar pa (* pi 0.75) rad)
                          (polar pa (* pi 1.75) rad) 7)
                  (setq pos (1+ pos)))
             (ssdel enam ss)))
  (if ss 
      (progn
           (command "erase" ss "")
           (write-line (strcat "Circles deleted: " (itoa pos))))
      (write-line "No Circles deleted."))
 ; Ŀ
 ;   Arcs: find all, mark and erase any below the minimum radius,          
 ;   remove others from the ss.                                            
 ; 
  (if (setq ss (ssget "X" (list (cons 0 "ARC"))))
      (setq num (itoa (sslength ss)))
      (setq num "0"))
  (write-line (strcat "\nArcs found: " num))
  (setq num (strcat "/" num))
  (setq pos 0)
  (setq curr 1)
  (while (and ss (setq enam (ssname ss pos)))
         (grtext -2 (strcat (itoa curr) num))
         (setq curr (1+ curr))
         (setq entt (entget enam))
         (setq pa (cdr (assoc 10 entt)))
         (setq diam (* 2 (cdr (assoc 40 entt))))
         (if (or (> mind diam)
                 (> mind (cartlg entt)))
             (progn
                  (grdraw (polar pa (/ pi 4) rad)
                          (polar pa (* 1.25 pi) rad) 7)
                  (grdraw (polar pa (* pi 0.75) rad)
                          (polar pa (* pi 1.75) rad) 7)
                  (setq pos (1+ pos)))
             (ssdel enam ss)))
  (if ss 
      (progn
           (command "erase" ss "")
           (write-line (strcat "Arcs deleted: " (itoa pos))))
      (write-line "No Arcs deleted."))
 ; Ŀ
 ;   Polylines: find all, mark and erase any below the minimum overall     
 ;   length, remove others from the ss.                                    
 ; 
  (if (setq ss (ssget "X" (list (cons 0 "POLYLINE"))))
      (setq num (itoa (sslength ss)))
      (setq num "0"))
  (write-line (strcat "\nPolylines found: " num))
  (setq num (strcat "/" num))
  (setq pos 0)
  (setq curr 1)
  (while (and ss (setq enam (ssname ss pos)))
         (grtext -2 (strcat (itoa curr) num))
         (setq curr (1+ curr))
         (setq entt (entget (entnext enam)))
         (setq pa (cdr (assoc 10 entt)))
         (if (> mind (tail enam))
             (progn
                  (grdraw (polar pa (/ pi 4) rad)
                          (polar pa (* 1.25 pi) rad) 7)
                  (grdraw (polar pa (* pi 0.75) rad)
                          (polar pa (* pi 1.75) rad) 7)
                  (setq pos (1+ pos)))
             (ssdel enam ss)))
  (if ss 
      (progn
           (command "erase" ss "")
           (write-line (strcat "Polylines deleted: " (itoa pos))))
      (write-line "No Polylines deleted."))
 (princ))